#!/bin/sh

DRIVER=arcmsr

echo "arcmsr driver pre-installation begining..."
KERNEL=`uname -r`
MACHINE=`uname -m`
echo "kernel $KERNEL on $MACHINE"
if [ -f modules.cgz ]; then
    gzip -dc modules.cgz | cpio -idum ${KERNEL}/${MACHINE}/${DRIVER}.ko.xz > /dev/null 2>/dev/null
    if [ ! -f ${KERNEL}/${MACHINE}/${DRIVER}.ko.xz ]; then
        echo "Error extracting driver, possible reason:"
        echo "  1.Driver disk corrupt"
        echo "  2.Driver disk is not for the OS being installed"
        echo "Please check the driver disk and the version of the installation medium."
	echo "If the issue still exists, please contact Areca support, support@areca.com.tw."
        exit 1
    fi
else
    echo "No driver archive found."
    exit 1
fi

modprobe sd_mod > /dev/null 2> /dev/null
insmod ${KERNEL}/${MACHINE}/${DRIVER}.ko.xz

echo "arcmsr driver installation step 1 completed."
